/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.util.Vector;
import jclass.bwt.JCSerializable;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.Chartable;
import jclass.chart.DataInterpretation;
import jclass.chart.DirectChartDataView;
import jclass.chart.DirectChartDataViewSeries;
import jclass.chart.EditableChartable;

class ArrayDataInterpretation
extends DataInterpretation
implements JCSerializable {
    ArrayDataInterpretation(ChartDataView chartDataView) {
        super(chartDataView);
    }

    void loadData(Chartable chartable) {
        int n = chartable.getNumRows();
        if (n < 2) {
            return;
        }
        ChartDataViewSeries[] chartDataViewSeriesArray = new ChartDataViewSeries[n - 1];
        this.view.getSeries();
        boolean bl = this.view.getIsBatched();
        this.view.setIsBatched(true);
        this.view.setSeries(null);
        this.view.setX(this.view.toDoubleArray(chartable.getRow(0)));
        int n2 = 1;
        while (n2 < n) {
            ChartDataViewSeries chartDataViewSeries;
            chartDataViewSeriesArray[n2 - 1] = chartDataViewSeries = new ChartDataViewSeries(null, this.view.toDoubleArray(chartable.getRow(n2)), this.view);
            chartDataViewSeries.setDrawingOrder(n2 - 1);
            ++n2;
        }
        this.view.setSeries(chartDataViewSeriesArray);
        this.view.changed = true;
        this.view.setIsBatched(bl);
    }

    void loadDirectData(Chartable chartable) {
        int n = chartable.getNumRows();
        if (n < 2) {
            return;
        }
        ChartDataViewSeries[] chartDataViewSeriesArray = new ChartDataViewSeries[n - 1];
        boolean bl = this.view.getIsBatched();
        this.view.setIsBatched(true);
        this.view.setSeries(null);
        int n2 = 1;
        while (n2 < n) {
            DirectChartDataViewSeries directChartDataViewSeries = new DirectChartDataViewSeries((DirectChartDataView)this.view);
            chartDataViewSeriesArray[n2 - 1] = directChartDataViewSeries;
            directChartDataViewSeries.setDrawingOrder(n2 - 1);
            ++n2;
        }
        this.view.setSeries(chartDataViewSeriesArray);
        this.view.changed = true;
        this.view.setIsBatched(bl);
    }

    boolean editPoint(int n, int n2, double d) {
        int n3 = n + 1;
        EditableChartable editableChartable = (EditableChartable)this.view.dataSource;
        return editableChartable.setDataItem(n3, n2, new Double(d));
    }

    void changeValue(int n, int n2) {
        double d = ((Number)this.view.dataSource.getDataItem(n, n2)).doubleValue();
        if (n == 0) {
            this.view.getX()[n2] = d;
            return;
        }
        ChartDataViewSeries chartDataViewSeries = this.view.getSeries(n - 1);
        chartDataViewSeries.getY()[n2] = d;
    }

    void addValue(int n, int n2) {
        ChartDataViewSeries[] chartDataViewSeriesArray;
        double[] dArray;
        if (n == 0) {
            dArray = this.view.getX();
        } else {
            chartDataViewSeriesArray = this.view.getSeries();
            dArray = chartDataViewSeriesArray[n - 1].getY();
        }
        double[] dArray2 = new double[dArray.length + 1];
        if (n2 != 0) {
            System.arraycopy(dArray, 0, dArray2, 0, n2);
        }
        dArray2[n2] = ((Number)this.view.dataSource.getDataItem(n, n2)).doubleValue();
        if (n2 != dArray2.length - 1) {
            System.arraycopy(dArray, n2, dArray2, n2 + 1, dArray2.length - n2 - 1);
        }
        if (n == 0) {
            this.view.setX(dArray2);
            return;
        }
        chartDataViewSeriesArray = this.view.getSeries();
        chartDataViewSeriesArray[n - 1].setY(dArray2);
    }

    void removeValue(int n, int n2) {
        ChartDataViewSeries[] chartDataViewSeriesArray;
        double[] dArray;
        if (n == 0) {
            dArray = this.view.getX();
        } else {
            chartDataViewSeriesArray = this.view.getSeries();
            dArray = chartDataViewSeriesArray[n - 1].getY();
        }
        double[] dArray2 = new double[dArray.length - 1];
        System.arraycopy(dArray, 0, dArray2, 0, n2);
        System.arraycopy(dArray, n2 + 1, dArray2, n2, dArray2.length - n2);
        if (n == 0) {
            this.view.setX(dArray2);
            return;
        }
        chartDataViewSeriesArray = this.view.getSeries();
        chartDataViewSeriesArray[n - 1].setY(dArray2);
    }

    void changeRow(int n, int n2) {
        if (n == 0) {
            this.view.setX(this.view.toDoubleArray(this.view.dataSource.getRow(0)));
            return;
        }
        ChartDataViewSeries[] chartDataViewSeriesArray = this.view.getSeries();
        ChartDataViewSeries chartDataViewSeries = new ChartDataViewSeries(null, this.view.toDoubleArray(this.view.dataSource.getRow(n)), this.view);
        chartDataViewSeries.label = chartDataViewSeriesArray[n - 1].label;
        chartDataViewSeries.name = chartDataViewSeriesArray[n - 1].name;
        chartDataViewSeriesArray[n - 1] = chartDataViewSeries;
        this.view.setSeries(chartDataViewSeriesArray);
    }

    void addRow(int n, int n2) {
        if (n == 0) {
            return;
        }
        ChartDataViewSeries chartDataViewSeries = new ChartDataViewSeries(null, this.view.toDoubleArray(this.view.dataSource.getRow(n)), this.view);
        this.view.addSeries(chartDataViewSeries);
    }

    void removeRow(int n, int n2) {
        if (n == 0) {
            return;
        }
        this.view.removeSeries(n - 1);
    }

    void changeColumn(int n, int n2) {
        super.changeColumn(n, n2);
    }

    void addColumn(int n, int n2) {
        super.addColumn(n, n2);
    }

    void removeColumn(int n, int n2) {
        super.removeColumn(n, n2);
    }

    void changePointLabel(int n, int n2) {
        super.changePointLabel(n, n2);
    }

    void changeSeriesName(int n, int n2) {
        if (n == 0) {
            return;
        }
        ChartDataViewSeries chartDataViewSeries = this.view.getSeries(n - 1);
        chartDataViewSeries.setName(this.view.dataSource.getSeriesName(n));
    }

    void changeSeriesLabel(int n, int n2) {
        if (n == 0) {
            return;
        }
        ChartDataViewSeries chartDataViewSeries = this.view.getSeries(n - 1);
        chartDataViewSeries.setLabel(this.view.dataSource.getSeriesLabel(n));
    }

    void reset(int n, int n2) {
        int n3;
        this.loadData(this.view.dataSource);
        String[] stringArray = this.view.dataSource.getPointLabels();
        if (stringArray != null) {
            this.view.pointLabels.removeAllElements();
            n3 = 0;
            while (n3 < stringArray.length) {
                this.view.pointLabels.addElement(stringArray[n3]);
                ++n3;
            }
        }
        n3 = 0;
        while (n3 < this.view.getNumSeries()) {
            ChartDataViewSeries chartDataViewSeries = this.view.getSeries(n3);
            chartDataViewSeries.name = this.view.dataSource.getSeriesName(n3);
            chartDataViewSeries.label = this.view.dataSource.getSeriesLabel(n3);
            ++n3;
        }
        this.view.name = this.view.dataSource.getName();
    }

    Vector getXVector(int n) {
        return this.view.dataSource.getRow(0);
    }

    Vector getYVector(int n) {
        return this.view.dataSource.getRow(n + 1);
    }

    double getX(int n, int n2) {
        Object object = this.view.dataSource.getDataItem(0, n2);
        try {
            return ((Number)object).doubleValue();
        }
        catch (Exception exception) {
            throw new RuntimeException("Chartable returned bad data object");
        }
    }

    double getY(int n, int n2) {
        Object object = this.view.dataSource.getDataItem(n + 1, n2);
        try {
            return ((Number)object).doubleValue();
        }
        catch (Exception exception) {
            throw new RuntimeException("Chartable returned bad data object");
        }
    }
}

